﻿#
# Name			: RDSXSConsole.ps1
# Description   : Connects to VM hosted on a XenServer hypervisor via Microsoft Remote Desktop Client
# Author 		: Ingmar Verheij - http://www.ingmarverheij.com/
# Version		: 1.0, 13 february 2012
#
# Requires		: plink (a command-line interface to the puTTY back ends)
#				  http://www.chiark.greenend.org.uk/~sgtatham/putty/download.html
#

function StartProcess([String]$FileName, [String]$Arguments){
    $process = New-Object "System.Diagnostics.Process"
    $startinfo = New-Object "System.Diagnostics.ProcessStartInfo"
    $startinfo.FileName = $FileName
    $startinfo.Arguments = $arguments 
    $startinfo.UseShellExecute = $false
    $startinfo.RedirectStandardInput = $true
    $startinfo.RedirectStandardOutput = $true
    $startinfo.WindowStyle = [System.Diagnostics.ProcessWindowStyle]::Hidden 
    $process.StartInfo = $startinfo
    $temp = $process.start()
    return $process
}

#Region PrequisiteCheck
   #Check number of arguments
   If ($args.count -lt 5)
   {
      Write-Host "Usage"
      Write-Host "powershell.exe .\RDSConnect.ps1 (XenServerPoolMaster) (XenServerUsername) (XenServerPassword) (VMName) (Network ID) [CustomFieldName] [CustomFieldValue]"
      Write-Host ""
      Write-Host "Example"
      Write-Host "powershell.exe .\RDSConnect.ps1 172.16.1.1 root Passw0rd WS01 0 STUDENT 1"
      Write-Host "" 
      Write-Host "Press any key to continue ..."
      $x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
      break
   }
#EndRegion
#Region Define variables and read
   
   #Executables
   $strExecutableMSTSC=((Get-Item "Env:WinDir").Value)+'\system32\mstsc.exe'
   $strExecutablePLink=(Split-Path -parent $MyInvocation.MyCommand.Definition) + '\plink.exe'
   
   #File paths
   $strPathTemp=$Env:TEMP
   $strFileQueryNetworks ='QueryNetworks'
   
   #Script variables
   $XenServerHost=$args[0]
   $XenServerUsername=$args[1]
   $XenServerPassword=$args[2]
   $VirtualMachineName=$args[3]
   $VirtualMachineNetworkID=$args[4].toString()
   If ($args.count -ge 7) {
   		$CustomFieldName=$args[5]
   		$CustomFieldValue=$args[6]
   } else {
   	  $CustomFieldName=""
   	  $CustomFieldValue=""
   }
   $strNICInterface=($VirtualMachineNetworkID)+'/ip: '
   
   #Filter variables
   $strFilterVM='name-label="' + $VirtualMachineName+'"'
   IF ($CustomFieldName) {$strFilterVM+=' other-config:XenCenter.CustomFields.' + $CustomFieldName + '=' + $CustomFieldValue}
#EndRegion



#Prevent rsa2 key fingerprint message
#====================================
#The server's host key is not cached in the registry. You have no guarantee that the server is the computer you #think it is. 
#The server's rsa2 key fingerprint is: ssh-rsa 2048 7c:99:f3:31:38:ca:b7:b6:3b:21:53:55:ff:f3:76:1e
#If you trust this host, enter "y" to add the key to PuTTY's cache and carry on connecting.
#If you want to carry on connecting just once, without adding the key to the cache, enter "n".
#If you do not trust this host, press Return to abandon the connection.
#
#Run plink and confirm rsa2 key fingerprint with yes
#---------------------------------------------------
$process = StartProcess $strExecutablePLink (' -l '+$XenServerUsername+' -pw '+$XenServerPassword+' '+$XenServerHost+' exit')
$process.StandardInput.WriteLine('y')


#Retrieve IP of VM
#=================
#
#Create a script to query a XenServer and ask the networks of the VM 
#-------------------------------------------------------------------
New-Item $strPathTemp -Name $strFileQueryNetworks -type file -Force  | Out-Null
Add-Content ($strPathTemp + '\' + $strFileQueryNetworks) -Value ('xe vm-list '+$strFilterVM+' os-version:distro="windows" params=networks --minimal')


#Run the script on the specified XenServer
#-----------------------------------------
$process = StartProcess $strExecutablePLink (' -l '+$XenServerUsername+' -pw '+$XenServerPassword+' '+$XenServerHost+' -m '+($strPathTemp + '\' + $strFileQueryNetworks))
$VMNetworks = $process.StandardOutput.ReadLine()
Remove-Item ($strPathTemp+'\'+$strFileQueryNetworks)


#Determine if the networks of the virtual machine can be found
#--------------------------------------------------------------
if(!$VMNetworks) {
   Write-Host "The virtual machine '"$VirtualMachineName"' could not be found."
   Write-Host "" 
   Write-Host "Press any key to continue ..."
   $x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
   break
} else {
   
   #Determine the IP address of the NIC can be found
   foreach ($strVMNetwork in $VMNetworks.Split(";")) {
      if ($strVMNetwork.Contains($strNICInterface)) {
	   $strVMIPaddress=$strVMNetwork.Substring($strVMNetwork.IndexOf($strNICInterface) + $strNICInterface.Length)
      }
   } 
   
   #Determine if the IP address of the network ID can be found
   #--------------------------------------------------------------
   if(!$strVMIPaddress) {
      Write-Host "The IP address of network '"$VirtualMachineNetworkID"' could not be found."
      Write-Host "" 
      Write-Host "Press any key to continue ..."
      $x = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
      break
   } 
   else {
	Write-Host "The virtual machine '"$VirtualMachineName"' is connected via IP "$strVMIPaddress
   }
}



#Start MSTSC to the VM
#======================
$processMSTSC=StartProcess $strExecutableMSTSC ('/v:'+$strVMIPaddress+' /f') 