param([String] $remoteHost,[string] $username="admin", [string] $password, [string] $enablepassword = $password, [int] $remotePort=23, [int] $timeout=30)
if(-not($remoteHost)) { Throw "You must supply a value for -remoteHost" }
if(-not($password)) { Throw "You must supply a value for -password" }

function readResponse ($stream)
{
   while($stream.DataAvailable)  
   {  
      $StreamRead = $stream.Read($buffer, 0, 1024)    
	  Return $encoding.GetString($buffer, 0, $StreamRead)
   } 
}
function waitResponse ($stream, [string] $expectedresponse, [ref]$refTotalResponse, [int]$timeout = 5)
{
	#Get current timestamp
	$dateStart = $(Get-Date)
	do
	{
	   #Read response
	   $strResponse = readResponse($stream)
	   if ($refTotalResponse -ne $null) { $refTotalResponse.value=$refTotalResponse.value+$strResponse }
	   #Determine if there is a result
	   if ($strResponse -ne $null) 
	   {
	   #Write-Host $strResponse
	      #Determine if response matches expected response
	      if ($strResponse.Contains($ExpectedResponse)) { Return $true }
	   }
	   #Sleep
	   start-sleep -m 100
	} until ((New-TimeSpan $dateStart $(Get-Date)).TotalSeconds -gt $timeout)
	#Timeout, so failed
	Return $false
}
<#
  This Export-CSV behaves exactly like native Export-CSV
  However it has one optional switch -Append
  Which lets you append new data to existing CSV file: e.g.
  Get-Process | Select ProcessName, CPU | Export-CSV processes.csv -Append
  
  For details, see
  http://dmitrysotnikov.wordpress.com/2010/01/19/export-csv-append/
  
  (c) Dmitry Sotnikov
#>
function Export-CSV {
[CmdletBinding(DefaultParameterSetName='Delimiter',
  SupportsShouldProcess=$true, ConfirmImpact='Medium')]
param(
 [Parameter(Mandatory=$true, ValueFromPipeline=$true,
           ValueFromPipelineByPropertyName=$true)]
 [System.Management.Automation.PSObject]
 ${InputObject},

 [Parameter(Mandatory=$true, Position=0)]
 [Alias('PSPath')]
 [System.String]
 ${Path},
 
 #region -Append (added by Dmitry Sotnikov)
 [Switch]
 ${Append},
 #endregion 

 [Switch]
 ${Force},

 [Switch]
 ${NoClobber},

 [ValidateSet('Unicode','UTF7','UTF8','ASCII','UTF32','BigEndianUnicode','Default','OEM')]
 [System.String]
 ${Encoding},

 [Parameter(ParameterSetName='Delimiter', Position=1)]
 [ValidateNotNull()]
 [System.Char]
 ${Delimiter},

 [Parameter(ParameterSetName='UseCulture')]
 [Switch]
 ${UseCulture},

 [Alias('NTI')]
 [Switch]
 ${NoTypeInformation})

begin
{
 # This variable will tell us whether we actually need to append
 # to existing file
 $AppendMode = $false
 
 try {
  $outBuffer = $null
  if ($PSBoundParameters.TryGetValue('OutBuffer', [ref]$outBuffer))
  {
      $PSBoundParameters['OutBuffer'] = 1
  }
  $wrappedCmd = $ExecutionContext.InvokeCommand.GetCommand('Export-Csv',
    [System.Management.Automation.CommandTypes]::Cmdlet)
        
        
	#String variable to become the target command line
	$scriptCmdPipeline = ''

	# Add new parameter handling
	#region Dmitry: Process and remove the Append parameter if it is present
	if ($Append) {
  
		$PSBoundParameters.Remove('Append') | Out-Null
    
  if ($Path) {
   if (Test-Path $Path) {        
    # Need to construct new command line
    $AppendMode = $true
    
    if ($Encoding.Length -eq 0) {
     # ASCII is default encoding for Export-CSV
     $Encoding = 'ASCII'
    }
    
    # For Append we use ConvertTo-CSV instead of Export
    $scriptCmdPipeline += 'ConvertTo-Csv -NoTypeInformation '
    
    # Inherit other CSV convertion parameters
    if ( $UseCulture ) {
     $scriptCmdPipeline += ' -UseCulture '
    }
    if ( $Delimiter ) {
     $scriptCmdPipeline += " -Delimiter '$Delimiter' "
    } 
    
    # Skip the first line (the one with the property names) 
    $scriptCmdPipeline += ' | Foreach-Object {$start=$true}'
    $scriptCmdPipeline += '{if ($start) {$start=$false} else {$_}} '
    
    # Add file output
    $scriptCmdPipeline += " | Out-File -FilePath '$Path' -Encoding '$Encoding' -Append "
    
    if ($Force) {
     $scriptCmdPipeline += ' -Force'
    }

    if ($NoClobber) {
     $scriptCmdPipeline += ' -NoClobber'
    }   
   }
  }
 } 
  

  
 $scriptCmd = {& $wrappedCmd @PSBoundParameters }
 
 if ( $AppendMode ) {
  # redefine command line
  $scriptCmd = $ExecutionContext.InvokeCommand.NewScriptBlock(
      $scriptCmdPipeline
    )
 } else {
  # execute Export-CSV as we got it because
  # either -Append is missing or file does not exist
  $scriptCmd = $ExecutionContext.InvokeCommand.NewScriptBlock(
      [string]$scriptCmd
    )
 }

 # standard pipeline initialization
 $steppablePipeline = $scriptCmd.GetSteppablePipeline($myInvocation.CommandOrigin)
 $steppablePipeline.Begin($PSCmdlet)
 
 } catch {
   throw
 }
    
}

process
{
  try {
      $steppablePipeline.Process($_)
  } catch {
      throw
  }
}

end
{
  try {
      $steppablePipeline.End()
  } catch {
      throw
  }
}
<#

.ForwardHelpTargetName Export-Csv
.ForwardHelpCategory Cmdlet

#>

}


#Connect to remote host
	$strPhase ="Connecting to remote host $remoteHost on port $remotePort" 
	$socket = new-object System.Net.Sockets.TcpClient($remoteHost, $remotePort) 
	if($socket -eq $null) { Write-Error -Message ("Error during '"+$strPhase+"'"); return; }


#Prepare session variables
	$stream = $socket.GetStream() 
	$writer = new-object System.IO.StreamWriter($stream) 
	$buffer = new-object System.Byte[] 1024 
	$encoding = new-object System.Text.AsciiEncoding 
	$dateNow = $(Get-Date)


#Authenticate
	$strPhase ="Wait for authentication challenge"
	if ((waitResponse -stream $stream -expectedresponse "Username" -timeout $timeout) -ne $true) { Write-Error -Message ("Timeout during '"+$strPhase+"'"); return; }
	$strPhase ="Send username"
	$command = $username; $writer.WriteLine($command); $writer.Flush();

	$strPhase ="Wait for password request"
	if ((waitResponse -stream $stream -expectedresponse "Password"-timeout  $timeout) -ne $true) { Write-Error -Message ("Timeout during '"+$strPhase+"'"); return; }
	$strPhase ="Send password"
	$command = $password; $writer.WriteLine($command); $writer.Flush();
	
	$strPhase ="Wait for shell prompt"
	$refTotalResponse=""
	if ((waitResponse -stream $stream -expectedresponse ">" -timeout $timeout -refTotalResponse ([ref]$refTotalResponse)) -ne $true) { Write-Error -Message ("Timeout during '"+$strPhase+"'"); return; }
        $strHostName = $refTotalResponse.SubString(1, $refTotalResponse.Length - 2)


#Set terminal buffer to 0
	$strPhase ="Execute command 'term len 0'"
	$command = "term len 0"; $writer.WriteLine($command); $writer.Flush();
	
	$strPhase ="Wait for shell to return"
	if ((waitResponse -stream $stream -expectedresponse ">" -timeout $timeout) -ne $true) { Write-Error -Message ("Timeout during '"+$strPhase+"'"); return; }


#Retrieve statistics
	$strPhase ="Execute command 'show flowcontrol'"
	$command = "show flowcontrol"; $writer.WriteLine($command); $writer.Flush();
	
	$strPhase ="Wait for shell to return"
	$refTotalResponse=""
	if ((waitResponse -stream $stream -expectedresponse ">" -timeout $timeout -refTotalResponse ([ref]$refTotalResponse)) -ne $true) { Write-Error -Message ("Timeout during '"+$strPhase+"'"); return; }


#Store results in CSV (via array)
	$i=1; $arrayFlowControl = @()
	foreach ($strLine in $refTotalResponse.split("`n"))
	{
	  #Skip the first 4 lines 
	  #1> show flow control
	  #2> Port       Send FlowControl  Receive FlowControl  RxPause TxPause
	  #3>            admin    oper     admin    oper
	  #4> ---------  -------- -------- -------- --------    ------- -------
	  #   11 char    9 chars  9 chars  9 chars 12 chars     8 chars 8 chars
	 
	  if ($i -gt 4)
	  {
	    #Determine if this is the shell prompt 
		if ($strLine.contains(">") -eq $false)
		{
			
		   #Retrieve content per subject
		   $fields=$strLine.Split(); $NextPosition=0
		   $Port = $fields[$NextPosition]; $NextPosition=$NextPosition+(11-$Port.Length)
		   $SendFlowAdmin = $fields[$NextPosition]; $NextPosition=$NextPosition+(9-$SendFlowAdmin.Length)
		   $ControlOper = $fields[$NextPosition]; $NextPosition=$NextPosition+(9-$ControlOper.Length)
		   $ReceiveAdmin = $fields[$NextPosition]; $NextPosition=$NextPosition+(9-$ReceiveAdmin.Length)
		   $FlowControlOper = $fields[$NextPosition]; $NextPosition=$NextPosition+(12-$FlowControlOper.Length)
		   $RxPause = $fields[$NextPosition]; $NextPosition=$NextPosition+(8-$RxPause.Length)
		   $TxPause = $fields[$NextPosition]
	       
		   #Add object to array
	       $objectFlowControl = new-object PSObject
		   $objectFlowControl | add-Member -memberType noteProperty -name "TimeStamp" -Value $dateNow
		   $objectFlowControl | add-Member -memberType noteProperty -name "Host" -Value $strHostName
	       $objectFlowControl | add-Member -memberType noteProperty -name "Port" -Value $Port
		   $objectFlowControl | add-Member -memberType noteProperty -name "SendFlowAdmin" -Value $SendFlowAdmin
		   $objectFlowControl | add-Member -memberType noteProperty -name "ControlOper" -Value $SendFlowAdmin
		   $objectFlowControl | add-Member -memberType noteProperty -name "ReceiveAdmin" -Value $ReceiveAdmin
		   $objectFlowControl | add-Member -memberType noteProperty -name "FlowControlOper" -Value $FlowControlOper
		   $objectFlowControl | add-Member -memberType noteProperty -name "RxPause" -Value $RxPause
		   $objectFlowControl | add-Member -memberType noteProperty -name "TxPause" -Value $TxPause
		   If ($Port.length -ne 0) { $arrayFlowControl += $objectFlowControl }
		}
	  }
	  $i=$i+1
	}


	#Export result to CSV
	$arrayFlowControl | export-csv -Path FlowControl.csv -NoTypeInformation -Append -Delimiter ([System.Globalization.CultureInfo]::CurrentCulture.TextInfo.ListSeparator)


#Close the streams 
$writer.Close() 
$stream.Close() 