﻿Function New-Enum ([string] $name)
{
	#http://blogs.msdn.com/b/powershell/archive/2007/01/23/how-to-create-enum-in-powershell.aspx
    $appdomain = [System.Threading.Thread]::GetDomain()
    $assembly = new-object System.Reflection.AssemblyName('IngmarVerheij')
	$assemblyBuilder = $appdomain.DefineDynamicAssembly($assembly, [System.Reflection.Emit.AssemblyBuilderAccess]::Save -bor [System.Reflection.Emit.AssemblyBuilderAccess]::Run);
    $moduleBuilder = $assemblyBuilder.DefineDynamicModule("DynamicModule", "DynamicModule.mod");
    $enumBuilder = $moduleBuilder.DefineEnum($name, [System.Reflection.TypeAttributes]::Public, [System.Int32]);
 
    for($i = 0; $i -lt $args.Length; $i++)
    {
        $null = $enumBuilder.DefineLiteral($args[$i], $i);
    }

	$enumBuilder.CreateType() > $null;
}
Function get-EnumMember ([type]$enum, [string]$name)
{
  #http://thepursuitofalife.com/howto-list-enum-values-in-powershell/
  [enum]::GetValues($enum) |  select @{Name='Value';e={[int]($_ -as $enum)}}, @{Name='Name';e={$_ -as $enum}} | Where-Object {$_.Name -eq $name}
}

#Create WanEm enums
New-Enum WanEmSymmetricalNetwork "Yes" "No"
New-Enum WanEmDelayDistribution "-N/A-" "Normal" "Pareto" "Paretonormal"
New-Enum WanEmDisconnectType "none" "tcp-reset" "icmp-net-unreachable" "icmp-host-unreachable" "icmp-port-unreachable" "icmp-proto-unreachable" "icmp-net-prohibited" "icmp-host-prohibited" "icmp-admin-prohibited"
#WanEmBandwidthPreset
	$appdomain = [System.Threading.Thread]::GetDomain()
    $assembly = new-object System.Reflection.AssemblyName('IngmarVerheij')
	$assemblyBuilder = $appdomain.DefineDynamicAssembly($assembly, [System.Reflection.Emit.AssemblyBuilderAccess]::Save -bor [System.Reflection.Emit.AssemblyBuilderAccess]::Run);
    $moduleBuilder = $assemblyBuilder.DefineDynamicModule("DynamicModule", "DynamicModule.mod");
    $enumBuilder = $moduleBuilder.DefineEnum('WanEmBandwidthPreset', [System.Reflection.TypeAttributes]::Public, [System.Int32]);
 	$null = $enumBuilder.DefineLiteral("Other", 0);
	$null = $enumBuilder.DefineLiteral("Modem", 9);
	$null = $enumBuilder.DefineLiteral("Level_1_cable", 20);
	$null = $enumBuilder.DefineLiteral("DS-0_Pulse_Code_Modulation", 64);
	$null = $enumBuilder.DefineLiteral("ISDN", 128);
	$null = $enumBuilder.DefineLiteral("T-1_DS-1_North_America", 1581);
	$null = $enumBuilder.DefineLiteral("E-1_DS-1_Europe", 2097);
	$null = $enumBuilder.DefineLiteral("DS-1c", 3228);
	$null = $enumBuilder.DefineLiteral("Standard_ADSL_downstream", 6291);
	$null = $enumBuilder.DefineLiteral("T-2_DS-2_North_America", 6463);
	$null = $enumBuilder.DefineLiteral("E-2_Europe", 8651);
	$null = $enumBuilder.DefineLiteral("Thin_Ethernet_CAT-3_cable", 10240);
	$null = $enumBuilder.DefineLiteral("Token_ring_LAN", 16384);
	$null = $enumBuilder.DefineLiteral("CAT-4_cable", 20480);
	$null = $enumBuilder.DefineLiteral("E-3_Europe", 35193);
	$null = $enumBuilder.DefineLiteral("T-3_DS-3_North_America", 45810);
	$null = $enumBuilder.DefineLiteral("OC-1_STS-1", 53084);
	$null = $enumBuilder.DefineLiteral("CDDI_FDDI_Fast_ethernet", 102400);
	$null = $enumBuilder.DefineLiteral("OC-3_STS-3_CAT-5_High_speed_ADSL_downstream", 159252);
	$null = $enumBuilder.DefineLiteral("OC-9", 477757);
	$null = $enumBuilder.DefineLiteral("OC-24", 1304000);
	$enumBuilder.CreateType() > $null;	

Function WANEmulator_Reset([string]$HostName, [int]$Interface=0)
{
	#Create a new web request
	$myHttpWebRequest = [System.Net.HttpWebRequest]::Create("http://$HostName/WANem/index-advanced.php")

	#Set web request to POST
	$myHttpWebRequest.Method = "POST"
    
	#--- Select interface ---
	#Create postdata
	$PostData = "selInt=eth$Interface&btnAdvanced=Start"

	#Encode the postdata
	$encoding = new-object System.Text.ASCIIEncoding
	$byte1 = $encoding.GetBytes($postData)

	#Set the contenttype
	$myHttpWebRequest.ContentType = "application/x-www-form-urlencoded"
	$myHttpWebRequest.ContentLength = $byte1.Length
	$myHttpWebRequest.CookieContainer = New-Object System.Net.CookieContainer

	#Post web request
	try
	{
		#Create write stream
		$newStream = $myHttpWebRequest.GetRequestStream()
		$newStream.Write($byte1, 0, $byte1.Length)
		
		#Close stream
		$newStream.Close()
	} Catch {
		Return $False
	}


	#Receive Response
	Try
	{
		$Response = $myHttpWebRequest.GetResponse()
		$SessionCookies = $Response.Cookies
		$SR = new-object System.IO.StreamReader $Response.GetResponseStream() 
		$ResponseData = $SR.ReadToEnd()
		$SR.Close()
		
	} Catch { 
		Return $False
	}


	#--- Set parameters ---
	#Create a new web request
	$myHttpWebRequest = [System.Net.HttpWebRequest]::Create("http://$HostName/WANem/index-advanced.php")

	#Set web request to POST
	$myHttpWebRequest.Method = "POST"

	#Create postdata
    $PostData = "" 
    $PostData = $PostData + "btnReset=True"

	#Encode the postdata
	$encoding = new-object System.Text.ASCIIEncoding
	$byte1 = $encoding.GetBytes($postData)

	#Set the contenttype
	$myHttpWebRequest.ContentType = "application/x-www-form-urlencoded"
	$myHttpWebRequest.ContentLength = $byte1.Length
	$myHttpWebRequest.CookieContainer = New-Object System.Net.CookieContainer
	$myHttpWebRequest.CookieContainer.Add($SessionCookies)

	#Post web request
	try
	{
		#Create write stream
		$newStream = $myHttpWebRequest.GetRequestStream()
		$newStream.Write($byte1, 0, $byte1.Length)
		
		#Close stream
		$newStream.Close()
	} Catch {
		Return $False
	}


	#Receive Response
	Try
	{
		$Response = $myHttpWebRequest.GetResponse()
		$SessionCookies = $Response.Cookies
		$SR = new-object System.IO.StreamReader $Response.GetResponseStream() 
		$ResponseData = $SR.ReadToEnd()
		$SR.Close()
		
	} Catch { 
		Return $False
	}

	Return $True
}
Function WANEmulator_Set
{
Param 
(
	[string]$HostName="127.0.0.1", [int]$Interface=0, 
	[int]$PacketLimit=1000, [WanEmSymmetricalNetwork]$SymmetricalNetwork="Yes",
	[WanEmBandwidthPreset]$BandwidthPreset=0, [int]$BandwidthSpecify=0,
	[int]$DelayTime=0, [int]$DelayJitter=0, [int]$DelayCorrelation=0, [WanEmDelayDistribution]$DelayDistribution="-N/A-",
	[int]$Loss=0, [int]$LossCorrelation=0,
	[int]$Duplication=0, [int]$DuplicationCorrelation=0,
	[int]$PacketReordering=0, [int]$PacketReorderingCorrelation=0, [int]$PacketReorderingGap=0,
	[int]$Corruption=0,
	[WanEmDisconnectType]$IdleTimerDisconnectType="none", [string]$IdleTimerDisconnectIdleTimer, [string]$IdleTimerDisconnectDiconnectTimer,
	[WanEmDisconnectType]$RandomDisconnectType="none", [string]$RandomDisconnectMTTFLow, [string]$RandomDisconnectMTTFHigh, [string]$RandomDisconnectMTTRLow, [string]$RandomDisconnectMTTRHigh,
	[WanEmDisconnectType]$RandomConnectionDisconnectType="none", [string]$RandomConnectionDisconnectMTTFLow, [string]$RandomConnectionDisconnectMTTFHigh, [string]$RandomConnectionDisconnectMTTRLow, [string]$RandomConnectionDisconnectMTTRHigh,
	[string]$IPSourceAddress="any", [string]$IPSourceSubnet, [string]$IPDestinationAddress="any", [string]$IPDestinationSubnet, [string]$ApplicationPortIfAny="any"
)

	#Create a new web request
	$myHttpWebRequest = [System.Net.HttpWebRequest]::Create("http://$HostName/WANem/index-advanced.php")

	#Set web request to POST
	$myHttpWebRequest.Method = "POST"
    
	#--- Select interface ---
	#Create postdata
	$PostData = "selInt=eth$Interface&btnAdvanced=Start"

	#Encode the postdata
	$encoding = new-object System.Text.ASCIIEncoding
	$byte1 = $encoding.GetBytes($PostData)

	#Set the contenttype
	$myHttpWebRequest.ContentType = "application/x-www-form-urlencoded"
	$myHttpWebRequest.ContentLength = $byte1.Length
	$myHttpWebRequest.CookieContainer = New-Object System.Net.CookieContainer

	#Post web request
	try
	{
		#Create write stream
		$newStream = $myHttpWebRequest.GetRequestStream()
		$newStream.Write($byte1, 0, $byte1.Length)
		
		#Close stream
		$newStream.Close()
	} Catch {
		Return $False
	}


	#Receive Response
	Try
	{
		$Response = $myHttpWebRequest.GetResponse()
		$SessionCookies = $Response.Cookies
		$SR = new-object System.IO.StreamReader $Response.GetResponseStream() 
		$ResponseData = $SR.ReadToEnd()
		$SR.Close()
		
	} Catch { 
		Return $False
	}


	#--- Set parameters ---
	#Create a new web request
	$myHttpWebRequest = [System.Net.HttpWebRequest]::Create("http://$HostName/WANem/index-advanced.php")

	#Set web request to POST
	$myHttpWebRequest.Method = "POST"

	#Create postdata
	            #Packet Limit - Symmetrical Network
    $PostData = "txtLimit1=$PacketLimit&selSym1=$SymmetricalNetwork&"
	
	            #Bandwidht
				#Choose BW - Other Specify BW(Kbps)
	If ($BandwidthPreset -eq "Other") {
		$PostData = $PostData + "txtBandwidthAuto1=Other&"
	} else { 
		$PostData = $PostData + "txtBandwidthAuto1="+(get-EnumMember WanEmBandwidthPreset $BandwidthPreset).Value+"&"
	} 
	$PostData = $PostData + "txtBandwidth1=$BandwidthSpecify&"

				#Delay
				#Delay time (ms) - Jitter (ms) - Correlation (%) - Distribution
	$PostData = $PostData + "txtDelay1=$DelayTime&txtDelayJitter1=$DelayJitter&txtDelayCorrelation1=$DelayCorrelation&selDelayDistribution1=$DelayDistribution&"
	
				#Loss
				#Loss(%) - Correlation (%)
	$PostData = $PostData + "txtLoss1=$Loss&txtLossCorrelation1=$LossCorrelation&"
	
				#Duplication
				#Duplication (%)
				#Correlation (%)
	$PostData = $PostData + "txtDup1=$Duplication&txtDupCorrelation1=$DuplicationCorrelation&"
	
				#Packet reordering
				#Reordering (%)
				#Correlation (%)
				#Gap(packets)
	$PostData = $PostData + "txtReorder1=$PacketReordering&txtReorderCorrelation1=$PacketReorderingCorrelation&txtGap1=$PacketReorderingGap&"
		
				#Corruption
				#Corruption(%)
	$PostData = $PostData + "txtCorrupt1=$Corruption&"
			
				#Idle timer Disconnect 
				#Type - Idle Timer - Disconnect Timer
	$PostData = $PostData + "selidtyp1=$IdleTimerDisconnectType&txtidtmr1=$IdleTimerDisconnectIdleTimer&txtidsctmr1=$IdleTimerDisconnectDiconnectTimer&"
		
				#Random Disconnect
				#Type - MTTF Low - MTTF High - MTTR Low - MTTR High
	$PostData = $PostData + "selrndtyp1=$RandomDisconnectType&txtrndmttflo1=$RandomDisconnectMTTFLow&txtrndmttfhi1=$RandomDisconnectMTTFHigh&txtrndmttrlo1=$RandomDisconnectMTTRLow&txtrndmttrhi1=$RandomDisconnectMTTRHigh&"
		
				#Random connection Disconnect
				#Type - MTTR Low - MTTF High - MTTR Low - MTTR High
	$PostData = $PostData + "selrcdtyp1=$RandomConnectionDisconnectType&txtrcdmttflo1=$RandomConnectionDisconnectMTTFLow&txtrcdmttfhi1=$RandomConnectionDisconnectMTTFHigh&txtrcdmttrlo1=$RandomConnectionDisconnectMTTRLow&txtrcdmttrhi1=$RandomConnectionDisconnectMTTRHigh&"
		
				#?
				#IP source address - IP source subnet - IP dest address - IP dest subnet - Application port if any
    $PostData = $PostData + "txtSrc1=$IPSourceAddress&txtSrcSub1=$IPSourceSubnet&txtDest1=$IPDestinationAddress&txtDestSub1=$IPDestinationSubnet&txtPort1=$ApplicationPortIfAny&"

	#SUBMIT
	$PostData = $PostData + "btnApply=Apply+settings"


	#Encode the postdata
	$encoding = new-object System.Text.ASCIIEncoding
	$byte1 = $encoding.GetBytes($PostData)

	#Set the contenttype
	$myHttpWebRequest.ContentType = "application/x-www-form-urlencoded"
	$myHttpWebRequest.ContentLength = $byte1.Length
	$myHttpWebRequest.CookieContainer = New-Object System.Net.CookieContainer
	$myHttpWebRequest.CookieContainer.Add($SessionCookies)

	#Post web request
	try
	{
		#Create write stream
		$newStream = $myHttpWebRequest.GetRequestStream()
		$newStream.Write($byte1, 0, $byte1.Length)
		
		#Close stream
		$newStream.Close()
	} Catch {
		Return $False
	}


	#Receive Response
	Try
	{
		$Response = $myHttpWebRequest.GetResponse()
		$SessionCookies = $Response.Cookies
		$SR = new-object System.IO.StreamReader $Response.GetResponseStream() 
		$ResponseData = $SR.ReadToEnd()
		$SR.Close()
		
	} Catch { 
		Return $False
	}

	Return $True
}


$strConfigurationDefaultWanEmHost="192.168.1.12"
$intConfigurationDefaultWanInterface=2


WANEmulator_Reset -HostName $strConfigurationDefaultWanEmHost -Interface $intConfigurationDefaultWanInterface 
WANEmulator_Set -HostName $strConfigurationDefaultWanEmHost -Interface $intConfigurationDefaultWanInterface -BandwidthPreset Modem